# 为什么要做产品变现？

> 想清楚为什么做，才能做得更好



大家好，我是鱼皮。在做一个产品前，我们首先要问清楚自己：**为什么要做它？**

然后才是怎么做、怎么做的更好。

这篇文章，我会以自己做 AI 产品的经历为例，给大家分享做产品变现前的思考方法。希望能帮助你在开始做产品前，想清楚自己的目标和方向。



## 利

为什么要做自己的 AI 产品，原因很简单，一个字：**利** 。

利即收益，但利不等同于金钱，而是可以体现在许多不同的层面，包括物质、精神、情感等等。像我早期做了 2 年的免费编程知识分享，那个时候是完全没有在乎 “物质” 的利的，更多的是因为兴趣、因为帮助到粉丝们的正反馈，也就是精神和情感上的利。

大家也经常听到一个词 **利他** 。为什么要利他？本质上也是利己。一方面获得了帮助他人的满足感 —— 精神和情感上的利，另一方面也能给自己带来相应的物质上的利，一举两得。所以这是我个人也比较推崇的做法。

那么我就开始思考：我做 AI 产品有哪些不同层面的利？



### 物质收益

开公司，做产品，肯定是希望能赚米的。

为什么做 AI 产品呢？不用说大家也知道，AI 现在是一个 “台风口”，比移动互联网更大的风口。

可惜刚开始我还没意识到这点，那会儿我还在腾讯打工，每天也没多少时间去关注 AI，以为又是一个自媒体带起来的噱头。但等到 2 - 3 月的时候，我就意识到不对劲了，因为不单单是国内外的大厂有动作，我身边 “不学无术” 的同事们，竟然也开始聊起 AI、聊起 GPT 了？！再加上自媒体平台有越来越多 AI 相关的爆款视频、每天都会出现意想不到的新动向，我才意识到：握草，机会来了啊！

所以实不相瞒，我的离职和 AI 有一定的原因，虽然早就计划好要离职了，但 AI 可以说是一脚把我从悬崖边上踹了下去。

总之，我很看好 AI 的发展，而 **走在时代的前面** 的人必然是能得到更大的物质收益的，所以我决定必须要 **入局 AI** ！



### 精神收益

除了物质收益外，我个人会更注重精神和情感上的收益。因为我自己一直是崇尚自由的性格，无论是之前做分享、还是后面做知识付费，这些都是我热爱的领域。我不希望为了物质而追求物质，让自己受到束缚。

而且就我观察和我同期做编程分享的账号来看，如果你本身并不热爱一件事，因为看到别人赚米而去模仿，可能也会有点儿蛋糕渣，但是做不大的。

而入局 AI 这件事、不断接触和学习前沿知识本身，我就觉得 “泰裤辣”！我自己本身非常爱尝试、爱分享，而且说实在的，目前我积累到的传统的前后端编程技术栈和开发经验已经完全足够我做出大多数产品了，我也非常想在一个新的领域争取自己的一席之地。而 AI，对我来说就是一个神秘陌生的全新领域，在学习实践它的过程中，我会感觉非常爽 —— 对我来说，这便是精神收益了。

想清楚自己的利，就可以开始进一步的思考了。



## 一问：为什么要做产品？

那怎么利用 AI 获得利呢？答案就在上文：**走在时代的前面** 。

只要你紧跟时代，走在别人前面，看到了别人看不到的机会、得到了别人得不到的信息，那么就可以有收益。

举些经典例子：

1. 做自媒体，分享 AI 生成的文本和图像，给不了解 AI 的人开开眼界
2. 做培训，分享 AI 系列教程，带不会玩 AI 的人认识 AI
3. 做产品，接入国内外的 AI 模型，让更多人用上 AI
4. 搞科研，了解国内外最新的技术，写出更优秀的论文



那么这么多种方式，我为什么选择 **做产品** 呢？

首先从难度来看，做自媒体和培训是绝大多数人都能做的、花点时间就行，而搞科研咱又不擅长，所以做产品是比较合适的。

产品的定义又有很多种，可能是一系列课、可能是一个应用、也可能是某种服务。而我选择把鱼聪明 AI 做成一个网站，主要是由于：

1. 自己在做网站方面的经验是比较丰富的，开发个网站很容易
2. 网站是一个使用成本很低的信息载体，面向的受众更广
3. 网站可以接入多种不同的技术和应用，有无限的潜能



从利来看，网站面向的用户更多、可以更灵活的开发应用，自然就有了更多机会。而持续打磨一个 “可能性无限” 的作品，也会让我感觉很爽，做网站就像养小孩一样，看着自己的孩子往前奔跑，会有很大的成就感。



## 二问：真的要做么？

虽然上面说了很多，但也只是把做 AI 产品纳入了 **可选** 计划列表，即 “可以做”。

但是究竟要不要做，还要和自己的其他计划放在一起进行对比分析，通过 **权衡性价比** 来确定。

这点时间有限的人来说，尤其重要。理想情况下，肯定是 “我全都要”，能获利的东西，只要我技术 OK，我都去做。但现实往往是，能同时做 2 - 3 件事，就已经很累了。所以必须有所取舍。

就像学编程的同学，在学习过程中肯定会遇到很多的 “机会”，进实验室、竞赛、实习、兼职等等，也会有很多的诱惑。但是要想清楚自己的目标，问一问自己：现在这个时候，我做这件事，真的是性价比最高的选择么？

回归到我自己身上，每天给自己安排 2 - 4 小时在产品探索上、还可以投入 2 名团队同学来协助开发，换算下来完成这款 AI 产品是完全可以接受的；得到的利也是无法估量的（毕竟不尝试一下谁也不知道）。所以不妨就 try 1 try~



## 三问：同类产品多，还做么？

在我要做 AI 产品前，很多同学都觉得现在网上已经有非常多同类的 “套壳” 产品了，但为什么我还要做呢？

1）机会仍然很多。

走出自己的圈子，通过调研我发现，真正了解和能用 AI 的还是极少数人，很多同学可能只是在自媒体上听说过 AI 相关的内容，但只是惊鸿一瞥，大多数人还是 “圈外人”。



2）“套壳” 就没有意义了么？

所谓的套壳，只是因为有前人给你铺好了路，这些是前人馈赠的资源，我们理应接受。但是并不是说套壳就不好、套壳就不能做，而是我们不能仅满足于套壳，仍然可以在此基础上增加自己的创新点，做一些自己的事情。

就跟做项目一样，你可以在完成了网上项目的基础上，考虑增加自己的扩展点，把它变成你自己独特的东西。

另外，很多程序员做技术久了，很容易陷进去，做什么东西都想着技术要多牛逼多牛逼，却忽视了技术本身是为了业务服务的、产品本身是给用户来用的。所以哪怕是同一类产品，也有用户体验、交互流程等很多可以优化创新的机会。



3）资源为王

现在这个环境，绝大多数的技术已经不再是难点了、产品创新也不再是难点了。说得现实一点，只要你有资源和一定的商业嗅觉，看到其他人的创新点，立刻就能有样学样地照搬过来，不是么？

在这种情况下，如果我有一定的前期流量，就能更轻松地度过产品的冷启动阶段，再多用一些，就能脱颖而出。



综合上面这些考虑，我基本确定了，是要做一款属于自己的 AI 产品了。但是在动手前，还要做一件事 —— 做好最坏的打算。



## 做好最坏的打算

这是我一贯的行事风格，在决定做一件事前，先给自己留条后路。

那做 AI 产品这件事，我最坏的情况是什么？

比如：赚不到米、浪费时间、搞心态、浪费了一些流量。

但是，往好处想，即使失败了：

1. 我总不会破产
2. 我的这套系统是可以留下来的
3. 我可以把这段经历和经验作为专栏分享给别人
4. 积累一段失败经验



用一段时间来试错，我是完全可以接受的。So，just do it！



---



## 写在最后

以上就是我在做产品前的思考过程。无论你是想用 Vibe Coding 做个人项目，还是想做一款能产生价值的产品，都建议先想清楚这几个问题：

1. 为什么要做这个产品？（利益分析）
2. 真的要做吗？（权衡性价比）
3. 有没有同类产品？还做吗？（竞争分析）
4. 最坏的情况是什么？（风险评估）

想清楚这些问题后，你会发现自己的目标更明确，做起来也更有动力。

在 Vibe Coding 时代，做产品的门槛已经很低了。只要你有想法、愿意尝试，就一定能做出有价值的东西。

加油，期待看到你的产品！💪


## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
